<div class="row">
    <div class="col-12 d-flex mb-5">
        @if (has_permission('admin.patients.add'))
            <x-admin.form.add-button title="{{ __('admin/patients.btn.add') }}"
                link="{{ route('admin.patients.add') }}" :margin="'mr-3'" :size="'sm'" :target="'true'" />
        @endif
        @if (has_permission('admin.appointments.add'))
            <x-admin.form.add-button title="{{ __('admin/appointments.btn.add') }}"
                link="{{ route('admin.appointments.add') }}" :margin="'mr-3'" :size="'sm'" :target="'true'" />
        @endif
        @if (has_permission('admin.complaints.add'))
            <x-admin.form.add-button title="{{ __('admin/complaints.btn.add') }}"
                link="{{ route('admin.complaints.add') }}" :margin="'mr-3'" :size="'sm'" :target="'true'" />
        @endif
        @if (has_permission('admin.users.add'))
            <x-admin.form.add-button title="{{ __('admin/users.btn.add') }}" link="{{ route('admin.users.add') }}"
                :margin="'mr-3'" :size="'sm'" :target="'true'" />
        @endif
        @if (has_permission('admin.services.add'))
            <x-admin.form.add-button title="{{ __('admin/treatments.btn.add') }}"
                link="{{ route('admin.treatments.add') }}" :margin="'mr-3'" :size="'sm'" :target="'true'" />
        @endif
    </div>
</div>
<div class="row">
    <div class="col-12 col-lg-6 col-xxl-3">
        <div class="card elevation-0 border">
            <div class="card-header">
                <div class="d-flex">
                    <h3 class="card-title">
                        <i class="ion ion-clipboard mr-1"></i>
                        {{ __('admin/dashboard.reception.in_reception') }}
                    </h3>
                    <div class="ml-auto">
                        <small class="text-muted">
                            {{ sprintf(__('admin/dashboard.reception.count'), $patients_in_reception->count()) }}
                        </small>
                    </div>
                </div>
                <div class="w-100 mt-3">
                    <select id="no-app-patients" class="selectpicker" data-size="5" data-live-search="true"></select>
                    <button type="button" id="btn-add-patient" class="btn btn-success btn-sm" data-toggle="modal"
                        data-target="#check-in-patient-modal" title="{{ __('admin/patients.btn.add') }}">
                        <i class="fas fa-user-plus"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <ul class="todo-list" data-widget="todo-list">
                    @if ($patients_in_reception)
                        @foreach ($patients_in_reception as $patient)
                            <li>
                                <div class="icheck-primary d-inline ml-2">
                                    <input type="checkbox" value="{{ $patient->appointment_id }}"
                                        name="app-check-in[]" id="admit-{{ $patient->appointment_id }}">
                                    <label for="admit-{{ $patient->appointment_id }}">
                                        <span class="text">{{ $patient->patient_name }}</span>
                                    </label>
                                </div>
                                <small class="badge badge-info"><i class="far fa-clock"></i>
                                    {{ date('h:i A', strtotime($patient->start_time)) }}
                                </small>
                            </li>
                        @endforeach
                    @else
                        {{ __('admin/dashboard.reception.no_patients') }}
                    @endif
                </ul>
            </div>
            <div class="card-footer d-flex">
                <button type="button" id="btn-admit" class="btn btn-success btn-sm ml-auto">
                    <i class="fas fa-sign-in-alt"></i>
                    {{ __('admin/common.buttons.admit') }}
                </button>
            </div>
        </div>
    </div>
    <div class="col-12 col-lg-6 col-xxl-3">
        <div id="busy-physicians" class="card card-danger">
            <div id="card-loading-overlay" class="is-active">
                <span class="fas fa-spinner fa-3x fa-spin"></span>
            </div>
            <div class="card-header">
                <h3 class="card-title">Busy Physician</h3>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool btn-refresh p-0" data-parent="#busy-physicians"
                        data-response="json" data-href="{{ route('admin.dashboard.get_busy_physicians') }}">
                        <i class="fas fa-sync-alt"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-12 mb-4">
        <div class="card border elevation-0">
            <div class="card-body">
                <h3 class="border-bottom pb-3">
                    {{ __('admin/dashboard.reception.app_title') }}
                </h3>
                {{-- <div class="table-toolbar mt-5 mb-3">
                    <div class="w-100 d-flex">
                        <x-admin.table.search :action="$search_form_action" :keywords="$search" />
                        <x-admin.table.rows-per-page :selected="$rows" />
                        <x-admin.form.reset-button link="{{ route('admin.dashboard') }}" />
                    </div>
                </div> --}}
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>{{ __('admin/appointments.columns.ref_number') }}</th>
                            <th>{{ __('admin/appointments.columns.patient_name') }}</th>
                            <th>{{ __('admin/appointments.columns.patient_mobile') }}</th>
                            <th>{{ __('admin/appointments.columns.treatment') }}</th>
                            <th>{{ __('admin/appointments.columns.start_time') }}</th>
                            <th>{{ __('admin/appointments.columns.status') }}</th>
                            <th>{{ __('admin/common.cols.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($appointments as $app)
                            <tr>
                                <td>{{ $app->ref_number }}</td>
                                <td>{{ $app->patient_name }}</td>
                                <td>{{ $app->patient_mobile }}</td>
                                <td>{{ $app->treatment }}</td>
                                <td>{{ date('h:i A', strtotime($app->start_time)) }}</td>
                                <td>{{ $app->status }}</td>
                                <td>
                                    <button type="button" class="btn btn-primary" data-toggle="modal"
                                        data-target="#admit-patient-modal">
                                        Check in
                                    </button>
                                    <button type="button" class="btn btn-primary" data-toggle="modal"
                                        data-target="#admit-patient-modal">
                                        Admit
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="admit-patient-modal" tabindex="-1" aria-labelledby="admit-patient-modal-label"
    data-backdrop="static" data-keyboard="false" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="admit-patient-modal-label">Admit Patient</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <ul class="list-unstyled">
                </ul>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-secondary btn-sm"
                    data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
                <button type="button" class="btn btn-primary">{{ __('admin/common.buttons.admit') }}</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="check-in-patient-modal" tabindex="-1" aria-labelledby="check-in-patient-modal-label"
    data-backdrop="static" data-keyboard="false" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="check-in-patient-modal-label">Check-in Patient</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <ul class="list-unstyled">
                </ul>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-secondary btn-sm"
                    data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
                <button type="button" class="btn btn-primary">{{ __('admin/common.buttons.check_in') }}</button>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {

        $('#admit-patient-modal').on('show.bs.modal	', function() {

            $.ajax({
                type: "GET",
                url: "{{ route('admin.dashboard.get_free_physicians') }}",
                dataType: "JSON",
                error: function(XMLHttpRequest) {
                    alert('error');
                    $('#loading-overlay').removeClass('is-active');
                },
                success: function(response) {

                    let html = '';

                    $.each(response.users, function(k, v) {
                        html += '<li class="mb-1">';
                        html += '<div class="sam-custom-radio">';
                        html += '<input type="radio" id="physician-' + k +
                            '" name="physician" data-id="' + v.id + '">';
                        html += '<label for="physician-' + k +
                            '" class="w-100 text-left">' + v.first_name + ' ' + v
                            .last_name + '</label>';
                        html += '</div>';
                        html += '</li>';
                    });

                    $('#admit-patient-modal').find('.modal-body ul').html(html);
                }
            });
        });
        $('.card-tools .btn-tool.btn-refresh').on('click', function() {

            let parent = $(this).data('parent');

            $.ajax({
                type: "GET",
                url: $(this).data('href'),
                dataType: $(this).data('response'),
                contentType: false,
                processData: false,
                cache: false,
                beforeSend: function() {
                    $('#card-loading-overlay').addClass('is-active');
                },
                error: function(XMLHttpRequest) {
                    alert('error');
                    $('#card-loading-overlay').removeClass('is-active');
                },
                success: function(response) {

                    let html = '<ul class="list-unstyled">';

                    $.each(response.users, function(k, v) {
                        html += '<li class="mb-1">';
                        html += '<label class="w-100 text-left">' + v.first_name +
                            ' ' + v.last_name + '</label>';
                        html += '</li>';
                    });

                    html += '</ul>';

                    $(parent).find('.card-body').html(html);
                },
                complete: function() {
                    $('#card-loading-overlay').removeClass('is-active');
                }
            });

        });

        $('.card-tools .btn-tool.btn-refresh').trigger('click');

        //-------------------------
        $('#check-in-patient-modal').on('show.bs.modal	', function() {

            $.ajax({
                type: "GET",
                url: "{{ route('admin.dashboard.get_no_app_patients') }}",
                dataType: "JSON",
                error: function(XMLHttpRequest) {
                    alert('error');
                    $('#loading-overlay').removeClass('is-active');
                },
                success: function(response) {

                    let html = '';

                    $.each(response.patients, function(k, v) {
                        html += '<li class="mb-1">';
                        html += '<div class="sam-custom-radio">';
                        html += '<input type="radio" id="physician-' + k +
                            '" name="physician" data-id="' + v.id + '">';
                        html += '<label for="physician-' + k +
                            '" class="w-100 text-left">' + v.first_name + ' ' + v
                            .last_name + '</label>';
                        html += '</div>';
                        html += '</li>';
                    });

                    $('#check-in-patient-modal').find('.modal-body ul').html(html);
                }
            });
        });

        $(document).on('keyup','.bs-searchbox input[type="search"]',function(){

            let keyword = $(this).val();

            if ( keyword.length < 3 ){
                return;
            }

            $.ajax({
                type: "GET",
                url: "{{ route('admin.dashboard.get_no_app_patients') }}" +'?sq=' + keyword ,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                cache: false,

                success: function(data) {

                    let html = '<option value="-1" disabled selected>-- Select --</option>';

                    $.each(data.patients, function(index, value) {

                        let full_name = value.first_name + ' ' + value.second_name + ' ' +
                            value.third_name + ' ' + value.last_name;

                        html += '<option data-subtext="' + value.mobile + '" value="' +
                            value.id + '">' + full_name + '</option>'

                    });

                    $('#no-app-patients').html(html);

                    $('#no-app-patients').removeAttr('disabled');
                    $('#no-app-patients').selectpicker('refresh');
                },
            });

        });



        $('#no-app-patients').on('changed.bs.select', function (e, clickedIndex, isSelected, previousValue) {

            // change to cheked in

        });


    });
</script>
